<?php

/* -----------------------------------------------------------------
 * 	$Id: zentralverkauf.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Zentralverkauf {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Zentralverkauf() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'selling';
        $this->v_module_name = 'Zentralverkauf.de';
        $this->v_module_homepage = 'www.zentralverkauf.de';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'zentralverkauf.csv';
        $this->v_filename = 'zentralverkauf.php';
        $this->v_keyname = 'ZENTRALVERKAUF';
        $this->v_linkname = 'zentralverkauf';
        $this->v_delimiter = '|';
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $p_products_array['products_description'] = trim(no_html($p_products_array['products_description']));
        $p_products_array['products_short_description'] = trim(no_html($p_products_array['products_short_description']));
        $p_products_array['packing_unit_value'] = $p_products_array['packing_unit_value'];
        $p_products_array['packing_unit_name'] = $p_products_array['packing_unit_name'];
        $p_products_array['packing_unit_refrence'] = $p_products_array['packing_unit_compare'];
        if ($p_products_array['products_stock'] < 1)
            $p_products_array['products_stock'] = 1;
        $p_products_array['products_model_type'] = '';
        if (strlen($p_products_array['products_ean']) > 3)
            $p_products_array['products_model_type'] = 'EAN';
        $p_products_array['products_group'] = $p_products_array['products_id'];
        $query = xtc_db_query("SELECT pov.products_options_values_id AS id,
                                   pov.products_options_values_name AS name
                            FROM " . TABLE_PRODUCTS_OPTIONS . " po,
                                 " . TABLE_PRODUCTS_OPTIONS_VALUES . " pov,
                                 " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                            WHERE pa.products_id = '" . (int) $p_products_array['products_id'] . "'
                            AND pov.products_options_values_id = pa.options_values_id
                            AND pov.language_id = '2'
                            GROUP BY pov.products_options_values_id
                            ORDER BY pov.products_options_values_id");
        $p_attribute_names = array();
        while ($entry = xtc_db_fetch_array($query))
            $p_attribute_names[] = $p_entry['name'];
        $p_products_array['products_attributes_string'] = implode(";", $p_attribute_names);
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_model'] = 'ART_NR';
        $t_csv_fields_array['products_id'] = 'ID_VK';
        $t_csv_fields_array['products_condition'] = 'KLASSE';
        $t_csv_fields_array['products_status'] = 'STATUS';
        $t_csv_fields_array['products_name'] = 'BEZEICHNUNG';
        $t_csv_fields_array['products_definition_type'] = 'DEF_ART';
        $t_csv_fields_array['manufacturers_name'] = 'DEF_1';
        $t_csv_fields_array['products_description'] = 'BESCHR_LANG';
        $t_csv_fields_array['products_short_description'] = 'BESCHR_KURZ';
        $t_csv_fields_array['products_model_type'] = 'KENZ_ART';
        $t_csv_fields_array['products_ean'] = 'KENZ_ID';
        $t_csv_fields_array['products_stock'] = 'ANG_MENGE';
        $t_csv_fields_array['packing_unit_name'] = 'MENGEN_EINHEIT';
        $t_csv_fields_array['packing_unit_value'] = 'ENTH_EINHEIT';
        $t_csv_fields_array['products_min_order'] = 'MIND_BEST_MENGE';
        $t_csv_fields_array['packing_unit_value'] = 'GRUNDP_INHALT';
        $t_csv_fields_array['packing_unit_name'] = 'GRUNDP_EINHEIT';
        $t_csv_fields_array['packing_unit_refrence'] = 'GRUNDP_REFMENGE';
        $t_csv_fields_array['not_set_1'] = 'VARIANTENSATZ_ID';
        $t_csv_fields_array['products_price'] = 'PREIS';
        $t_csv_fields_array['products_retailprice'] = 'UVP';
        $t_csv_fields_array['products_tax'] = 'MWST';
        $t_csv_fields_array['products_shippingdays'] = 'VERS_ZEIT';
        $t_csv_fields_array['products_weight'] = 'VERS_EINHEITEN';
        $t_csv_fields_array['products_shipping_group'] = 'VERS_GRUPPE';
        $t_csv_fields_array['products_shipping_addition'] = 'VERS_AUFSCHL';
        $t_csv_fields_array['products_shipping_addition_type'] = 'VERS_AUFSCHL_BER';
        $t_csv_fields_array['products_discount_id'] = 'RABATTSATZ_ID';
        $t_csv_fields_array['products_image_1'] = 'BILD_1';
        $t_csv_fields_array['products_image_2'] = 'BILD_2';
        $t_csv_fields_array['products_image_3'] = 'BILD_3';
        $t_csv_fields_array['products_image_4'] = 'BILD_4';
        $t_csv_fields_array['products_image_5'] = 'BILD_5';
        $t_csv_fields_array['products_cat_id'] = 'KAT_ID_VK';
        $t_csv_fields_array['products_categories'] = 'KAT_BAUM_VK';
        $t_csv_fields_array['products_keywords'] = 'KEYWORDS';
        $t_csv_fields_array['products_cross_selling'] = 'CROSS_SELLING';
        $t_csv_fields_array['products_group'] = 'VAR_GRUPPE';
        $t_csv_fields_array['products_attributes_string'] = 'VAR_ATTRIBUTE';
        return($t_csv_fields_array);
    }

}

?>